/**
 *  PDFObject v2.1.1
 *  https://github.com/pipwerks/PDFObject
 *  @license
 *  Copyright (c) 2008-2018 Philip Hutchison
 *  MIT-style license: http://pipwerks.mit-license.org/
 *  UMD module pattern from https://github.com/umdjs/umd/blob/master/templates/returnExports.js
 */
!function(root,factory){"function"==typeof define&&define.amd?define([],factory):"object"==typeof module&&module.exports?module.exports=factory():root.PDFObject=factory()}(this,function(){"use strict";if("undefined"==typeof window||"undefined"==typeof navigator)return!1;var supportsPDFs,supportsPdfActiveX,createAXO,buildFragmentString,log,embedError,embed,getTargetElement,generatePDFJSiframe,generateEmbedElement,ua=window.navigator.userAgent,supportsPdfMimeType=void 0!==navigator.mimeTypes&&void 0!==navigator.mimeTypes["application/pdf"],isModernBrowser=void 0!==window.Promise,isFirefoxWithPDFJS=-1!==ua.indexOf("irefox")&&18<parseInt(ua.split("rv:")[1].split(".")[0],10),isIOS=/iphone|ipad|ipod/i.test(ua.toLowerCase());return createAXO=function(type){var ax;try{ax=new ActiveXObject(type)}catch(e){ax=null}return ax},supportsPdfActiveX=function(){return!(!createAXO("AcroPDF.PDF")&&!createAXO("PDF.PdfCtrl"))},supportsPDFs=!isIOS&&(isFirefoxWithPDFJS||supportsPdfMimeType||function(){return!!(window.ActiveXObject||"ActiveXObject"in window)}()&&supportsPdfActiveX()),buildFragmentString=function(pdfParams){var prop,string="";if(pdfParams){for(prop in pdfParams)pdfParams.hasOwnProperty(prop)&&(string+=encodeURIComponent(prop)+"="+encodeURIComponent(pdfParams[prop])+"&");string=string&&(string="#"+string).slice(0,string.length-1)}return string},log=function(msg){"undefined"!=typeof console&&console.log&&console.log("[PDFObject] "+msg)},embedError=function(msg){return log(msg),!1},getTargetElement=function(targetSelector){var targetNode=document.body;return"string"==typeof targetSelector?targetNode=document.querySelector(targetSelector):"undefined"!=typeof jQuery&&targetSelector instanceof jQuery&&targetSelector.length?targetNode=targetSelector.get(0):void 0!==targetSelector.nodeType&&1===targetSelector.nodeType&&(targetNode=targetSelector),targetNode},generatePDFJSiframe=function(targetNode,url,pdfOpenFragment,PDFJS_URL,id){var fullURL=PDFJS_URL+"?file="+encodeURIComponent(url)+pdfOpenFragment,iframe="<div style='"+(isIOS?"-webkit-overflow-scrolling: touch; overflow-y: scroll; ":"overflow: hidden; ")+"position: absolute; top: 0; right: 0; bottom: 0; left: 0;'><iframe  "+id+" src='"+fullURL+"' style='border: none; width: 100%; height: 100%;' frameborder='0'></iframe></div>";return targetNode.className+=" pdfobject-container",targetNode.style.position="relative",targetNode.style.overflow="auto",targetNode.innerHTML=iframe,targetNode.getElementsByTagName("iframe")[0]},generateEmbedElement=function(targetNode,targetSelector,url,pdfOpenFragment,width,height,id){var style="";return style=targetSelector&&targetSelector!==document.body?"width: "+width+"; height: "+height+";":"position: absolute; top: 0; right: 0; bottom: 0; left: 0; width: 100%; height: 100%;",targetNode.className+=" pdfobject-container",targetNode.innerHTML="<embed "+id+" class='pdfobject' src='"+url+pdfOpenFragment+"' type='application/pdf' style='overflow: auto; "+style+"'/>",targetNode.getElementsByTagName("embed")[0]},embed=function(url,targetSelector,options){if("string"!=typeof url)return embedError("URL is not valid");targetSelector=void 0!==targetSelector&&targetSelector;var pdfOpenFragment,id=(options=void 0!==options?options:{}).id&&"string"==typeof options.id?"id='"+options.id+"'":"",page=!!options.page&&options.page,pdfOpenParams=options.pdfOpenParams?options.pdfOpenParams:{},fallbackLink=void 0===options.fallbackLink||options.fallbackLink,width=options.width?options.width:"100%",height=options.height?options.height:"100%",assumptionMode="boolean"!=typeof options.assumptionMode||options.assumptionMode,forcePDFJS="boolean"==typeof options.forcePDFJS&&options.forcePDFJS,PDFJS_URL=!!options.PDFJS_URL&&options.PDFJS_URL,targetNode=getTargetElement(targetSelector),fallbackHTML="";return targetNode?(page&&(pdfOpenParams.page=page),pdfOpenFragment=buildFragmentString(pdfOpenParams),forcePDFJS&&PDFJS_URL?generatePDFJSiframe(targetNode,url,pdfOpenFragment,PDFJS_URL,id):supportsPDFs||assumptionMode&&isModernBrowser&&!isIOS?generateEmbedElement(targetNode,targetSelector,url,pdfOpenFragment,width,height,id):PDFJS_URL?generatePDFJSiframe(targetNode,url,pdfOpenFragment,PDFJS_URL,id):(fallbackLink&&(fallbackHTML="string"==typeof fallbackLink?fallbackLink:"<p>This browser does not support inline PDFs. Please download the PDF to view it: <a href='[url]'>Download PDF</a></p>",targetNode.innerHTML=fallbackHTML.replace(/\[url\]/g,url)),embedError("This browser does not support embedded PDFs"))):embedError("Target element cannot be determined")},{embed:function(a,b,c){return embed(a,b,c)},pdfobjectversion:"2.1.1",supportsPDFs:supportsPDFs}});
(function ($) {
	'use strict';
	$( document ).ready(function() {
		var selector = $('.embedpress-embed-document-pdf');
		if(selector.length){
			selector.each(function(index, value) {
				var $this = $(this),
					id = $this.data('emid'),
					src = $this.data('emsrc');
				PDFObject.embed(src, "."+id);
			});
		}
	});

})(jQuery);
