<?php
/**
 * Plugin Name: Embed docs
 * Plugin URI:  https://wordpress.org/plugins/embed-docs
 * Description:       Embed documents in WordPress plugin lets you embed any kind of files such as PDF, Word, Excel, and PowerPoint with ease in your WordPress websites.
 * Version:           1.0.0
 * Requires at least: 5.2
 * Tested up to:   6.0
 * Requires PHP:      7.2
 * Author:            A1Office
 * Author URI:       http://a1office.co/
 * Licence:           GPL v2 or later
 * Licence URI:    https://www.gnu.org/licenses/gpl-2.0.html
 */

if( ! defined ('ABSPATH')){
    exit;
}

if ( ! function_exists( 'ed_fs' ) ) {
    // Create a helper function for easy SDK access.
    function ed_fs() {
        global $ed_fs;

        if ( ! isset( $ed_fs ) ) {
            // Include Freemius SDK.
            require_once dirname(__FILE__) . '/freemius/start.php';

            $ed_fs = fs_dynamic_init( array(
                'id'                  => '10963',
                'slug'                => 'embed-docs',
                'type'                => 'plugin',
                'public_key'          => 'pk_91386343739dc7b0e242898e72bce',
                'is_premium'          => false,
                'has_addons'          => false,
                'has_paid_plans'      => false,
                'menu'                => array(
                'slug'                => 'embed-docs',
                'account'             => false,
                'support'             => false,
                ),
            ) );
        }

        return $ed_fs;
    }

    // Init Freemius.
    ed_fs();
    // Signal that SDK was initiated.
    do_action( 'ed_fs_loaded' );
}
 

function file_uploader_custom_block_script_register()
{
	wp_enqueue_script( 'file_uploader_custom_block', plugin_dir_url( __FILE__ ).'file_uploader_custom_block.js', array('wp-blocks', 'wp-i18n', 'wp-editor'), true, false );
	wp_enqueue_style( 'style', plugin_dir_url( __FILE__ ).'file_uploader_custom_block.css');
}

add_action('enqueue_block_editor_assets', 'file_uploader_custom_block_script_register');

function register_embed_file_widget( $widgets_manager ) {

	require_once( __DIR__ . '/widgets/embed-file-widget-excel.php' );
	require_once( __DIR__ . '/widgets/embed-file-widget-pdf.php' );
	require_once( __DIR__ . '/widgets/embed-file-widget-ppt.php' );
	require_once( __DIR__ . '/widgets/embed-file-widget-docs.php' );

	$widgets_manager->register( new \Elementor_embed_file_Widget_excel() );
	$widgets_manager->register( new \Elementor_embed_file_Widget_pdf() );
	$widgets_manager->register( new \Elementor_embed_file_Widget_ppt() );
	$widgets_manager->register( new \Elementor_embed_file_Widget_docs() );

}
add_action( 'elementor/widgets/register', 'register_embed_file_widget' );