// pro-plugin/helpers.js
import { addFilter } from '@wordpress/hooks';
import { SelectControl, TextControl, RangeControl, ToggleControl, Button } from '@wordpress/components';
import { MediaUpload } from '@wordpress/block-editor';

// import { MediaUpload, MediaUploadCheck } from "@wordpress/block-editor";

import AdTemplate from '../../../../embedpress/Gutenberg/src/common/ads-template';

import { Dashicon } from '@wordpress/components';


import { __ } from '@wordpress/i18n';

addFilter(
    'embedpress.adManagerSettings',  // Hook name
    'embedpress/withProAdManagerFeatures',  // Unique identifier
    (settings, attributes, setAttributes) => {
        const { adManager, adSource, adFileUrl, adWidth, adHeight, adXPosition, adYPosition, adUrl, adStart, adSkipButton, adSkipButtonAfter, adLabel } = attributes;

        if (adManager) {
            settings.push(
                <div className={'ad-manager-controllers'} key="pro-ad-settings">
                    <SelectControl
                        label={__("Ad Source")}
                        value={adSource}
                        options={[
                            { label: 'Upload Video', value: 'video' },
                            { label: 'Upload Image', value: 'image' },
                            { label: 'URL', value: 'url' },
                        ]}
                        onChange={(adSource) => setAttributes({ adSource })}
                        __nextHasNoMarginBottom
                    />
                    <div className='ad-upload'>
                        <label className="custom-share-thumbnail-label">{adLabel}</label>
                        {adFileUrl && <AdTemplate attributes={attributes} setAttributes={setAttributes} />}
                        {adSource !== 'url' ? (
                            <div className={'ep-custom-logo-button'}>

                                <MediaUpload
                                    onSelect={(file) => setAttributes({ adFileUrl: file.url })}
                                    allowedTypes={['image', 'video']}
                                    value={adFileUrl}
                                    render={({ open }) => (
                                        <Button className={'ep-logo-upload-button'} icon={!adFileUrl ? 'upload' : 'update'} onClick={open}>
                                            {!adFileUrl ? 'Upload Ad' : 'Change Ad'}
                                        </Button>
                                    )}
                                />

                            </div>
                        ) : (
                            <TextControl
                                value={adFileUrl}
                                onChange={(adFileUrl) => setAttributes({ adFileUrl })}
                            />
                        )}
                    </div>
                    {adSource === 'image' && (
                        <div>
                            <TextControl
                                label={__("Ad Width")}
                                value={adWidth}
                                onChange={(adWidth) => setAttributes({ adWidth })}
                            />
                            <TextControl
                                label={__("Ad Height")}
                                value={adHeight}
                                onChange={(adHeight) => setAttributes({ adHeight })}
                            />
                            <RangeControl
                                label={__('Ad X position(%)', 'embedpress')}
                                value={adXPosition}
                                onChange={(adXPosition) => setAttributes({ adXPosition })}
                                max={100}
                                min={0}
                            />
                            <RangeControl
                                label={__('Ad Y position(%)', 'embedpress')}
                                value={adYPosition}
                                onChange={(adYPosition) => setAttributes({ adYPosition })}
                                max={100}
                                min={0}
                            />
                        </div>
                    )}
                    <TextControl
                        label={__("Ad URL")}
                        value={adUrl}
                        onChange={(adUrl) => setAttributes({ adUrl })}
                    />
                    <TextControl
                        label={__("Ad Start After (sec)")}
                        value={adStart}
                        onChange={(adStart) => setAttributes({ adStart })}
                    />
                    <ToggleControl
                        label={__("Ad Skip Button")}
                        checked={adSkipButton}
                        onChange={(adSkipButton) => setAttributes({ adSkipButton })}
                    />
                    {adSkipButton && adSource !== 'image' && (
                        <TextControl
                            label={__("Skip Button After (sec)")}
                            value={adSkipButtonAfter}
                            onChange={(adSkipButtonAfter) => setAttributes({ adSkipButtonAfter })}
                        />
                    )}
                </div>
            );
        }

        return settings;
    }
);

addFilter(
    'embedpress.adsSettings',  // Hook name
    'embedpress/withProAdManagerFeatures',  // Unique identifier
    (settings, attributes, setAttributes) => {

        const { adManager } = attributes;

        settings.push(
            <ToggleControl
                label={__("Ads Settings", "embedpress")}
                checked={adManager}
                onChange={(adManager) => setAttributes({ adManager })}
            />
        );


        return settings;
    }
);

// Call this function in your plugin's main file
