// pro-plugin/helpers.js
import { addFilter } from '@wordpress/hooks';
import { ToggleControl } from '@wordpress/components';


import { __ } from '@wordpress/i18n';


addFilter(
    'embedpress.calendlyControls',  // Hook name
    'embedpress/withProCalendlyFeatures',  // Unique identifier
    (settings, attributes, setAttributes, controlName, props = {}) => {

        const { calendlyData } = attributes;


        if (controlName == 'calendlyData') {
            settings.push(
                <div className={"pro-control-active"}>
                    <ToggleControl
                        label={__("Calendly Data")}
                        checked={calendlyData}
                        onChange={(calendlyData) => setAttributes({ calendlyData })}
                    />
                </div>
            );
        }
        return settings;
    }
);

// Call this function in your plugin's main file
