// pro-plugin/helpers.js
import { addFilter } from '@wordpress/hooks';
import { SelectControl, TextControl, RangeControl, ToggleControl, Button, ColorPalette, PanelRow } from '@wordpress/components';
import { MediaUpload } from '@wordpress/block-editor';

// import { MediaUpload, MediaUploadCheck } from "@wordpress/block-editor";

import { __ } from '@wordpress/i18n';


addFilter(
    'embedpress.commonControls',  // Hook name
    'embedpress/withProCommonFeatures',  // Unique identifier
    (settings, attributes, setAttributes, controlName, props = {}) => {


        if (controlName == 'warningInfo') {
            settings.push(
                <PanelRow className="elementor-panel-alert elementor-panel-warning-info">
                    To embed #hashtag posts you need to connect business account. <a href="https://embedpress.com/docs/generate-instagram-access-token/">Learn More</a>
                </PanelRow>
            );
        }
        return settings;
    }
);

// Call this function in your plugin's main file
