// pro-plugin/helpers.js
import { addFilter } from '@wordpress/hooks';
import { MediaUpload } from '@wordpress/block-editor';
import { Button } from '@wordpress/components';

import { RangeControl, TextControl } from '@wordpress/components';
import { __ } from '@wordpress/i18n';

export function addProFeatures() {

    addFilter(
        'embedpress.customLogoSettings',
        'embedpress/withProFeatures',
        (settings, attributes, setAttributes) => {
            const { customlogo, logoX, logoY, logoOpacity, customlogoUrl } = attributes;

            const onSelectImage = (logo) => {
                setAttributes({ customlogo: logo.sizes.full.url });
            }
            const removeImage = (e) => {
                setAttributes({ customlogo: '' });
            }

            settings.push(

                <div className={'ep-custom-logo-position'} key="pro-settings">

                    {
                        customlogo && (
                            <div className={'ep__custom-logo'} style={{ position: 'relative' }}>
                                <button title="Remove Image" className="ep-remove__image" type="button" onClick={removeImage} >
                                    <span class="dashicon dashicons dashicons-trash"></span>
                                </button>
                                <img
                                    src={customlogo}
                                    alt="John"
                                />
                            </div>
                        )
                    }

                    <div className={"pro-control-active ep-custom-logo-button"}>
                        <MediaUpload
                            onSelect={onSelectImage}
                            allowedTypes={['image']}
                            value={customlogo}
                            render={({ open }) => (
                                <Button className={'ep-logo-upload-button'} icon={!customlogo ? 'upload' : 'update'} onClick={open}>
                                    {
                                        (!customlogo) ? 'Upload Image' : 'Change Image'
                                    }
                                </Button>
                            )}

                        />
                    </div>
                    {customlogo && (
                        <div>
                            <RangeControl
                                label={__('Logo X position (%)', 'embedpress-pro')}
                                value={logoX}
                                onChange={(logoX) => setAttributes({ logoX })}
                                max={100}
                                min={0}
                            />
                            <RangeControl
                                label={__('Logo Y position (%)', 'embedpress-pro')}
                                value={logoY}
                                onChange={(logoY) => setAttributes({ logoY })}
                                max={100}
                                min={0}
                            />
                            <RangeControl
                                label={__('Logo Opacity', 'embedpress-pro')}
                                value={logoOpacity}
                                onChange={(logoOpacity) => setAttributes({ logoOpacity })}
                                max={1}
                                min={0}
                                step={0.05}
                            />
                            <TextControl
                                label="CTA Link"
                                value={customlogoUrl}
                                onChange={(customlogoUrl) => setAttributes({ customlogoUrl })}
                                placeholder={'https://example.com'}
                            />
                        </div>
                    )}

                </div>
            );

            return settings;
        }
    );

    addFilter(
        'embedpress.customLogoComponent',
        'embedpress/withProFeatures',
        (settings, attributes) => {

            const {
                customlogo,
                logoX,
                logoY,
                customlogoUrl,
                logoOpacity
            } = attributes;

            if (customlogo) {
                let customLogoTemp = '';
                let customLogoStyle = `
                    border: 0;
                    position: absolute;
                    bottom: ${logoY}%;
                    right: ${logoX}%;
                    max-width: 150px;
                    max-height: 75px;
                    opacity: ${logoOpacity};
                    z-index: 5;
                    -o-transition: opacity 0.5s ease-in-out;
                    -moz-transition: opacity 0.5s ease-in-out;
                    -webkit-transition: opacity 0.5s ease-in-out;
                    transition: opacity 0.5s ease-in-out;
                `;

                customLogoTemp = `<img decoding="async"  src="${customlogo}" class="watermark ep-custom-logo" width="auto" height="auto" style="${customLogoStyle}">`;

                if (customlogoUrl) {
                    customLogoTemp = `<a href="${customlogoUrl}" target="_blank"><img decoding="async" src="${customlogo}" class="watermark  ep-custom-logo" width="auto" height="auto" style="${customLogoStyle}"></a>`;
                }

                settings.push(customLogoTemp);
            }

            return settings;
        }
    );

}


addProFeatures();