// pro-plugin/helpers.js
import { addFilter } from '@wordpress/hooks';
import { SelectControl, TextControl, RangeControl, ToggleControl, Button, ColorPalette } from '@wordpress/components';
import { MediaUpload } from '@wordpress/block-editor';

// import { MediaUpload, MediaUploadCheck } from "@wordpress/block-editor";

import { __ } from '@wordpress/i18n';

import ControlHeader from '../../../../embedpress/Gutenberg/src/common/control-heading';


addFilter(
    'embedpress.documentControls',  // Hook name
    'embedpress/withProDocumentFeatures',  // Unique identifier
    (settings, attributes, setAttributes, controlName, props = {}) => {

        const { toolbar, download } = attributes;

        if (controlName == 'toolbar') {
            settings.push(
                <div className={"pro-control-active"}>
                    <ToggleControl
                        label={__('Toolbar', 'embedpress')}
                        description={__('Show or Hide toolbar. Note: If you disable toolbar access then every toolbar options will be disabled', 'embedpress')}
                        onChange={(toolbar) =>
                            setAttributes({ toolbar })
                        }
                        checked={toolbar}
                        style={{ marginTop: '30px' }}
                    />
                </div>
            );
        }

        if (controlName == 'print') {
            settings.push(
                <div className={"pro-control-active"}>
                    <ToggleControl
                        label={__('Print/Download', 'embedpress')}
                        onChange={(download) =>
                            setAttributes({ download })
                        }
                        checked={download}
                    />
                </div>
            );
        }

        return settings;
    }
);

// Call this function in your plugin's main file
