// pro-plugin/helpers.js
import { addFilter } from '@wordpress/hooks';
import { ToggleControl, Button } from '@wordpress/components';

import { MediaUpload } from '@wordpress/block-editor';


import { __ } from '@wordpress/i18n';


addFilter(
    'embedpress.instafeedControls',  // Hook name
    'embedpress/withProInstafeedFeatures',  // Unique identifier
    (settings, attributes, setAttributes, controlName, props = {}) => {

        const { instafeedProfileImageUrl, instafeedTab, instafeedLikesCount, instafeedCommentsCount } = attributes;

        const onSelectImage = (logo) => {
            console.log(logo.sizes.full.url);
            setAttributes({ instafeedProfileImageUrl: logo.sizes.full.url });
        }
        const removeImage = (e) => {
            setAttributes({ instafeedProfileImageUrl: '' });
        }

        console.log(controlName);


        if (controlName == 'profileImage') {
            settings.push(
                <div className={"pro-control-active"}>

                    <MediaUpload
                        onSelect={onSelectImage}
                        allowedTypes={['image']}
                        value={instafeedProfileImageUrl}
                        render={({ open }) => (
                            <Button className={'ep-logo-upload-button instagram-profile-image-uploader'} icon={!instafeedProfileImageUrl ? 'upload' : 'update'} onClick={open}>
                                {
                                    (!instafeedProfileImageUrl) ? 'Upload Image' : 'Change Image'
                                }
                            </Button>
                        )}
                    />
                </div>
            );
        }
        if (controlName == 'feedTab') {
            settings.push(
                <div className={"pro-control-active"}>
                    <ToggleControl
                        label={__('Feed Tab', 'embedpress')}
                        checked={instafeedTab}
                        onChange={(instafeedTab) => setAttributes({ instafeedTab })}
                    />
                </div>
            );
        }
        if (controlName == 'likesCount') {
            settings.push(
                <div className={"pro-control-active"}>

                    <ToggleControl
                        label={__('Likes Count', 'embedpress')}
                        checked={instafeedLikesCount}
                        onChange={(instafeedLikesCount) => setAttributes({ instafeedLikesCount })}
                    />
                </div>
            );
        }

        if (controlName == 'commentsCount') {
            settings.push(
                <div className={"pro-control-active"}>

                    <ToggleControl
                        label={__('Comments Count', 'embedpress')}
                        checked={instafeedCommentsCount}
                        onChange={(instafeedCommentsCount) => setAttributes({ instafeedCommentsCount })}
                    />
                </div>
            );
        }
        return settings;
    }
);

// Call this function in your plugin's main file
