// pro-plugin/helpers.js
import { addFilter } from '@wordpress/hooks';
import {
    ToggleControl,
    RangeControl,
    TextControl,
    PanelBody,
    ColorPalette,
    FontSizePicker,
} from '@wordpress/components';

import { MediaUpload } from '@wordpress/block-editor';


import { __ } from '@wordpress/i18n';
import ControlHeader from '../../../../embedpress/Gutenberg/src/common/control-heading';


addFilter(
    'embedpress.openseaControls',  // Hook name
    'embedpress/withProOpenseaFeatures',  // Unique identifier
    (settings, attributes, setAttributes, controlName, props = {}) => {

        const {
            prefix_nftcreator,
            prefix_nftprice,
            prefix_nftlastsale,
            label_nftbutton,
            label_nftrank,
            label_nftdetails,
            loadmore,
            itemperpage,
            loadmorelabel,
            loadmoreTextColor,
            loadmoreBackgroundColor,
            loadmoreTextFontsize,

        } = attributes;

        const colors = [
            { name: '', color: 'red' },
            { name: '', color: 'green' },
            { name: '', color: 'blue' },
            { name: '', color: 'yellow' },
            { name: '', color: 'orange' },
        ];

        const fontSizes = [
            {
                name: __('Small'),
                slug: 'small',
                size: 16,
            },
            {
                name: __('Medium'),
                slug: 'medium',
                size: 18,
            },
            {
                name: __('Large'),
                slug: 'big',
                size: 26,
            },
        ];

        const fallbackFontSize = 16;



        if (controlName == 'creatorPrefix') {
            settings.push(
                <div className={"pro-control-active"}>
                    <TextControl
                        label={__("Creator Prefix", "embedpress")}
                        value={prefix_nftcreator}
                        onChange={(prefix_nftcreator) => setAttributes({ prefix_nftcreator })}
                    />
                </div>
            );
        }
        if (controlName == 'pricePrefix') {
            settings.push(
                <div className={"pro-control-active"}>
                    <TextControl
                        label={__("Price Prefix", "embedpress")}
                        value={prefix_nftprice}
                        onChange={(prefix_nftprice) => setAttributes({ prefix_nftprice })}
                    />
                </div>
            );
        }
        if (controlName == 'lastSalePrefix') {
            settings.push(
                <div className={"pro-control-active"}>
                    <TextControl
                        label={__("Last Sale Prefix", "embedpress")}
                        value={prefix_nftlastsale}
                        onChange={(prefix_nftlastsale) => setAttributes({ prefix_nftlastsale })}
                    />
                </div>
            );
        }
        if (controlName == 'buttonLabel') {
            settings.push(
                <div className={"pro-control-active"}>
                    <TextControl
                        label={__("Button Label", "embedpress")}
                        value={label_nftbutton}
                        onChange={(label_nftbutton) => setAttributes({ label_nftbutton })}
                    />
                </div>
            );
        }
        if (controlName == 'rankLabel') {
            settings.push(
                <div className={"pro-control-active"}>
                    <TextControl
                        label={__("Rank Label", "embedpress")}
                        value={label_nftrank}
                        onChange={(label_nftrank) => setAttributes({ label_nftrank })}
                    />
                </div>
            );
        }
        if (controlName == 'detailsLabel') {
            settings.push(
                <div className={"pro-control-active"}>
                    <TextControl
                        label={__("Details Label", "embedpress")}
                        value={label_nftdetails}
                        onChange={(label_nftdetails) => setAttributes({ label_nftdetails })}
                    />
                </div>
            );
        }
        if (controlName == 'loadMore') {
            settings.push(
                <div className={"pro-control-active"}>
                    <ToggleControl
                        label={__("Load More", "embedpress")}
                        checked={loadmore}
                        onChange={(loadmore) => setAttributes({ loadmore })}
                    />

                    {
                        loadmore && (
                            <div>
                                <RangeControl
                                    label={__("Item Per Page", "embedpress")}
                                    value={itemperpage}
                                    onChange={(itemperpage) => setAttributes({ itemperpage })}
                                    min={1}
                                    max={100}
                                />

                                <TextControl
                                    label={__("Load More Label", "embedpress")}
                                    value={loadmorelabel}
                                    onChange={(loadmorelabel) => setAttributes({ loadmorelabel })}
                                />
                            </div>

                        )
                    }
                </div>
            );
        }
        if (controlName == 'loadmorePanelBody') {
            settings.push(
                <PanelBody title={__("Load More")} initialOpen={false}>

                    <ControlHeader headerText={'Color'} />
                    <ColorPalette
                        label={__("Text Color")}
                        colors={colors}
                        value={loadmoreTextColor}
                        onChange={(loadmoreTextColor) => setAttributes({ loadmoreTextColor })}
                    />

                    <ControlHeader headerText={'Background Color'} />
                    <ColorPalette
                        label={__("Color")}
                        colors={colors}
                        value={loadmoreBackgroundColor}
                        onChange={(loadmoreBackgroundColor) => setAttributes({ loadmoreBackgroundColor })}
                    />

                    <ControlHeader headerText={'Font Size'} />
                    <FontSizePicker
                        __nextHasNoMarginBottom
                        fontSizes={fontSizes}
                        value={loadmoreTextFontsize}
                        fallbackFontSize={fallbackFontSize}
                        onChange={(loadmoreTextFontsize) => setAttributes({ loadmoreTextFontsize })}
                    />
                </PanelBody>
            );
        }
        return settings;
    }
);

// Call this function in your plugin's main file
