// pro-plugin/helpers.js
import { addFilter } from '@wordpress/hooks';
import { SelectControl, TextControl, RangeControl, ToggleControl, Button, ColorPalette } from '@wordpress/components';
import { MediaUpload } from '@wordpress/block-editor';

// import { MediaUpload, MediaUploadCheck } from "@wordpress/block-editor";

import { __ } from '@wordpress/i18n';

import ControlHeader from '../../../../embedpress/Gutenberg/src/common/control-heading';

console.log('update control heading');

addFilter(
    'embedpress.pdfControls',  // Hook name
    'embedpress/withProPdfFeatures',  // Unique identifier
    (settings, attributes, setAttributes, controlName, props = {}) => {

        const { toolbar, download, draw, copy_text, selection_tool, scrolling } = attributes;


        if (controlName == 'toolbar') {
            settings.push(
                <div className={"pro-control-active"}>
                    <ToggleControl
                        label={__('Toolbar', 'embedpress')}
                        description={__('Show or Hide toolbar. Note: If you disable toolbar access then every toolbar options will be disabled', 'embedpress')}
                        onChange={(toolbar) =>
                            setAttributes({ toolbar })
                        }
                        checked={toolbar}
                        style={{ marginTop: '30px' }}
                    />
                </div>
            );
        }

        if (controlName == 'print') {
            settings.push(
                <div className={"pro-control-active"}>
                    <ToggleControl
                        label={__('Print/Download', 'embedpress')}
                        onChange={(download) =>
                            setAttributes({ download })
                        }
                        checked={download}
                    />
                </div>
            );
        }
        if (controlName == 'draw') {
            settings.push(
                <div className={"pro-control-active"}>
                    <ToggleControl
                        label={__('Draw', 'embedpress')}
                        onChange={(draw) =>
                            setAttributes({ draw })
                        }
                        checked={draw}
                    />
                </div>
            );
        }
        if (controlName == 'copyText') {
            settings.push(
                <div className={"pro-control-active"}>
                    <ToggleControl
                        label={__('Copy Text', 'embedpress')}
                        onChange={(copy_text) =>
                            setAttributes({ copy_text })
                        }
                        checked={copy_text}
                        className={'disabled'}
                    />
                </div>
            );
        }
        if (controlName == 'selectionTool') {
            settings.push(
                <div className={"pro-control-active"}>
                    <SelectControl
                        label="Default Selection Tool"
                        value={selection_tool}
                        options={[
                            { label: 'Text Tool', value: '0' },
                            { label: 'Hand Tool', value: '1' },
                        ]}
                        onChange={(selection_tool) =>
                            setAttributes({ selection_tool })
                        }
                        __nextHasNoMarginBottom
                    />
                </div>
            );
        }
        if (controlName == 'scrolling') {
            settings.push(
                <div className={"pro-control-active"}>
                    <SelectControl
                        label="Default Scrolling"
                        value={scrolling}
                        options={[
                            { label: 'Page Scrolling', value: '-1' },
                            { label: 'Vertical Scrolling', value: '0' },
                            { label: 'Horizontal Scrolling', value: '1' },
                            { label: 'Wrapped Scrolling', value: '2' },
                        ]}
                        onChange={(scrolling) =>
                            setAttributes({ scrolling })
                        }
                        __nextHasNoMarginBottom
                    />
                </div>
            );
        }

        return settings;
    }
);

// Call this function in your plugin's main file
