// pro-plugin/helpers.js
import { addFilter } from '@wordpress/hooks';
import { SelectControl, TextControl, RangeControl, ToggleControl, Button, ColorPalette } from '@wordpress/components';
import { MediaUpload } from '@wordpress/block-editor';

// import { MediaUpload, MediaUploadCheck } from "@wordpress/block-editor";

import { __ } from '@wordpress/i18n';

import ControlHeader from '../../../../embedpress/Gutenberg/src/common/control-heading';

addFilter(
    'embedpress.spreakerControls',  // Hook name
    'embedpress/withProSpreakerFeatures',  // Unique identifier
    (settings, attributes, setAttributes, controlName, props = {}) => {

        const { isYTVideo, isYTLive, isYTShorts, isVimeoVideo, isSelfHostedAudio } = props;

        const {
            hideDownload,
            playlistContinuous,
            playlistLoop,
            coverImageUrl,
        } = attributes;

        const onSelectImage = (logo) => {
            setAttributes({ coverImageUrl: logo.sizes.full.url });
        }
        const removeImage = (e) => {
            setAttributes({ coverImageUrl: '' });
        }


        if (controlName == 'hideDownload') {
            settings.push(
                <div className={"pro-control-active"}>
                    <ToggleControl
                        label={__('Disable Download', 'embedpress')}
                        checked={hideDownload}
                        onChange={(hideDownload) => setAttributes({ hideDownload })}
                    />
                </div>
            );
        }
        if (controlName == 'playlistContinuous') {
            settings.push(
                <div className={"pro-control-active"}>
                    <ToggleControl
                        label={__('Continuous Playlist', 'embedpress')}
                        checked={playlistContinuous}
                        onChange={(playlistContinuous) => setAttributes({ playlistContinuous })}
                    />
                </div>
            );
        }

        // Render 'Loop Playlist' only if 'Continuous Playlist' is enabled
        if (controlName == 'playlistLoop' && playlistContinuous) {
            settings.push(
                <div className={"pro-control-active"}>
                    <ToggleControl
                        label={__('Loop Playlist', 'embedpress')}
                        checked={playlistLoop}
                        onChange={(playlistLoop) => setAttributes({ playlistLoop })}
                    />
                </div>
            );
        }


        if (controlName == 'coverImage') {

            settings.push(
                <div>

                    {
                        coverImageUrl && (
                            <div className={'ep__custom-logo'} style={{ position: 'relative' }}>
                                <button title="Remove Image" className="ep-remove__image" type="button" onClick={removeImage} >
                                    <span class="dashicon dashicons dashicons-trash"></span>
                                </button>
                                <img
                                    src={coverImageUrl}
                                    alt="John"
                                />
                            </div>
                        )
                    }


                    <div className={'pro-control-active ep-custom-logo-button'}>
                        <MediaUpload
                            onSelect={onSelectImage}
                            allowedTypes={['image']}
                            value={coverImageUrl}
                            render={({ open }) => (
                                <Button className={'ep-logo-upload-button'} icon={!coverImageUrl ? 'upload' : 'update'} onClick={open}>
                                    {
                                        (!coverImageUrl) ? 'Upload Image' : 'Change Image'
                                    }
                                </Button>
                            )}

                        />
                    </div>

                </div>
            );
        }

        return settings;
    }
);

// Call this function in your plugin's main file
