// pro-plugin/helpers.js
import { addFilter } from '@wordpress/hooks';
import { SelectControl, TextControl, RangeControl, ToggleControl, Button, ColorPalette } from '@wordpress/components';
import { MediaUpload } from '@wordpress/block-editor';

// import { MediaUpload, MediaUploadCheck } from "@wordpress/block-editor";

import { __ } from '@wordpress/i18n';

import ControlHeader from '../../../../embedpress/Gutenberg/src/common/control-heading';

addFilter(
    'embedpress.vimeoControls',  // Hook name
    'embedpress/withProVimeoFeatures',  // Unique identifier
    (settings, attributes, setAttributes, controlName, props = {}) => {

        const { isYTVideo, isYTLive, isYTShorts, isVimeoVideo, isSelfHostedAudio } = props;

        const {
            vautopause,
            vdnt,
            vloop
        } = attributes;

        const colors = [
            { name: '', color: '#FF0000' },
            { name: '', color: '#00FF00' },
            { name: '', color: '#5b4e96' },
            { name: '', color: '#0000FF' },
            { name: '', color: '#FFA500' },
        ];


        const onSelectImage = (logo) => {
            setAttributes({ posterThumbnail: logo.sizes.full.url });
        }
        const removeImage = (e) => {
            setAttributes({ posterThumbnail: '' });
        }

        if (controlName == 'loop') {
            settings.push(
                <div className={'pro-control-active'}>
                    <ToggleControl
                        label={__("Loop")}
                        checked={vloop}
                        onChange={(vloop) => setAttributes({ vloop })}
                    />
                </div>
            );

        }
        if (controlName == 'autoPause') {
            settings.push(
                <div className={'pro-control-active'}>
                    <ToggleControl
                        label={__("Auto Pause")}
                        checked={vautopause}
                        onChange={(vautopause) => setAttributes({ vautopause })}
                    />
                    <p className={'is-ep-description'}>{__('Automatically stop the current video from playing when another one starts.', 'embedpress')}</p>
                </div>
            );

        }
        if (controlName == 'dnt') {
            settings.push(
                <div className={'pro-control-active'}>
                    <ToggleControl
                        label={__("DNT")}
                        checked={vdnt}
                        onChange={(vdnt) => setAttributes({ vdnt })}
                    />
                    <p className={'is-ep-description'}>{__('Enabling this will block session data tracking, including cookies. If Auto Pause is enabled this will not work.', 'embedpress')}</p>
                </div>
            );

        }

        return settings;
    }
);

// Call this function in your plugin's main file
