// pro-plugin/helpers.js
import { addFilter } from '@wordpress/hooks';
import { RangeControl, ToggleControl } from '@wordpress/components';

// import { MediaUpload, MediaUploadCheck } from "@wordpress/block-editor";

import { __ } from '@wordpress/i18n';


addFilter(
    'embedpress.wistiaControls',  // Hook name
    'embedpress/withProWistiaFeatures',  // Unique identifier
    (settings, attributes, setAttributes, controlName, props = {}) => {

        const {
            volumecontrol,
            volume,
            captions
        } = attributes;

        const colors = [
            { name: '', color: '#FF0000' },
            { name: '', color: '#00FF00' },
            { name: '', color: '#5b4e96' },
            { name: '', color: '#0000FF' },
            { name: '', color: '#FFA500' },
        ];


        const onSelectImage = (logo) => {
            setAttributes({ posterThumbnail: logo.sizes.full.url });
        }
        const removeImage = (e) => {
            setAttributes({ posterThumbnail: '' });
        }

        if (controlName == 'captions') {
            settings.push(
                <div className={'pro-control-active'}>
                    <ToggleControl
                        label={__("Captions")}
                        checked={captions}
                        onChange={(captions) => setAttributes({ captions })}
                    />
                </div>
            );

        }
        if (controlName == 'volumeRange') {
            settings.push(
                <div className={'pro-control-active'}>
                    <ToggleControl
                        label={__("Volume Control")}
                        checked={volumecontrol}
                        onChange={(volumecontrol) => setAttributes({ volumecontrol })}
                    />
                </div>
            );

        }
        if (controlName == 'volumeRange') {
            settings.push(
                <div className={'pro-control-active'}>
                    <RangeControl
                        label={__("Volume", "embedpress")}
                        value={volume}
                        onChange={(volume) => setAttributes({ volume })}
                        min={1}
                        max={100}
                    />
                </div>
            );

        }

        return settings;
    }
);

// Call this function in your plugin's main file
