// pro-plugin/helpers.js
import { addFilter } from '@wordpress/hooks';
import { SelectControl, TextControl, RangeControl, ToggleControl, Button, ColorPalette } from '@wordpress/components';
import { MediaUpload } from '@wordpress/block-editor';

// import { MediaUpload, MediaUploadCheck } from "@wordpress/block-editor";

import { __ } from '@wordpress/i18n';

import ControlHeader from '../../../../embedpress/Gutenberg/src/common/control-heading';

addFilter(
    'embedpress.youtubeControls',  // Hook name
    'embedpress/withProYoutubeFeatures',  // Unique identifier
    (settings, attributes, setAttributes, controlName, props = {}) => {

        const { isYTVideo, isYTLive, isYTShorts, isVimeoVideo, isSelfHostedAudio } = props;

        const {
            closedcaptions,
            modestbranding,
            playerPreset,
            playerColor,
            posterThumbnail,
            playerPip,
            playerTooltip,
            playerHideControls,
            playerDownload
        } = attributes;

        const colors = [
            { name: '', color: '#FF0000' },
            { name: '', color: '#00FF00' },
            { name: '', color: '#5b4e96' },
            { name: '', color: '#0000FF' },
            { name: '', color: '#FFA500' },
        ];


        const onSelectImage = (logo) => {
            setAttributes({ posterThumbnail: logo.sizes.full.url });
        }
        const removeImage = (e) => {
            setAttributes({ posterThumbnail: '' });
        }

        if (controlName == 'closedCaptions') {
            settings.push(
                <div className={"pro-control-active"} >
                    <ToggleControl
                        label={__("Closed Captions")}
                        checked={closedcaptions}
                        onChange={(closedcaptions) => setAttributes({ closedcaptions })}
                    />
                </div>
            );
        }
        if (controlName == 'modestBranding') {
            settings.push(
                <div className={"pro-control-active"}>
                    <SelectControl
                        label={__("Modest Branding", "embedpress")}
                        value={modestbranding}
                        options={[
                            { label: 'Display', value: '0' },
                            { label: 'Do Not Display', value: '1' },
                        ]}
                        onChange={(modestbranding) => setAttributes({ modestbranding })}
                        className={'ep-select-control-field'}
                        __nextHasNoMarginBottom
                    />
                </div>
            );
        }

        if (controlName == 'playerColor') {
            settings.push(
                <div className={'pro-control-active'}>
                    <ControlHeader headerText={'Player Color'} />
                    <ColorPalette
                        label={__("Player Color")}
                        colors={colors}
                        value={playerColor}
                        onChange={(playerColor) => setAttributes({ playerColor })}
                    />
                </div>
            );
        }
        if (controlName == 'tooltip') {
            settings.push(
                <div className={"pro-control-active"}>
                    <ToggleControl
                        label={__("Tooltip")}
                        checked={playerTooltip}
                        onChange={(playerTooltip) => setAttributes({ playerTooltip })}
                    />
                </div>
            );
        }
        if (controlName == 'autoHide') {
            settings.push(
                !isSelfHostedAudio && (
                    <div className={"pro-control-active"}>
                        <ToggleControl
                            label={__("Auto Hide Controls")}
                            checked={playerHideControls}
                            onChange={(playerHideControls) => setAttributes({ playerHideControls })}
                        />
                    </div>
                )
            );
        }
        if (controlName == 'sourceLink') {
            settings.push(
                <div className={"pro-control-active"}>
                    <ToggleControl
                        label={__('Source Link')}
                        checked={playerDownload}
                        onChange={(playerDownload) => setAttributes({ playerDownload })}
                    />
                </div>
            );
        }
        if (controlName == 'stickyVideo') {
            settings.push(
                !isSelfHostedAudio && (
                    <div className={"pro-control-active"}>
                        <ToggleControl
                            label={__("Sticky Video")}
                            checked={playerPip}
                            onChange={(playerPip) => setAttributes({ playerPip })}
                        />
                        <p className={'is-ep-description'}>{__("Watch video and seamlessly scroll through other content with a sleek pop-up window.")}</p>
                    </div>
                )
            );
        }
        if (controlName == 'preset') {
            settings.push(
                !isSelfHostedAudio && (
                    <div className={'pro-control-active'}>
                        <SelectControl
                            label={__("Preset")}
                            value={playerPreset}
                            options={[
                                { label: 'Default', value: 'preset-default' },
                                { label: 'Preset 1', value: 'custom-player-preset-1' },
                                { label: 'Preset 2', value: 'custom-player-preset-3' },
                            ]}
                            onChange={(playerPreset) => setAttributes({ playerPreset })}
                            __nextHasNoMarginBottom
                        />
                    </div>
                )
            );
        }

        if (controlName == 'thumbnail') {

            settings.push(
                <div>

                    {
                        posterThumbnail && (
                            <div className={'ep__custom-logo'} style={{ position: 'relative' }}>
                                <button title="Remove Image" className="ep-remove__image" type="button" onClick={removeImage} >
                                    <span class="dashicon dashicons dashicons-trash"></span>
                                </button>
                                <img
                                    src={posterThumbnail}
                                    alt="John"
                                />
                            </div>
                        )
                    }


                    <div className={'pro-control-active ep-custom-logo-button'}>
                        <MediaUpload
                            onSelect={onSelectImage}
                            allowedTypes={['image']}
                            value={posterThumbnail}
                            render={({ open }) => (
                                <Button className={'ep-logo-upload-button'} icon={!posterThumbnail ? 'upload' : 'update'} onClick={open}>
                                    {
                                        (!posterThumbnail) ? 'Upload Image' : 'Change Image'
                                    }
                                </Button>
                            )}

                        />
                    </div>

                </div>
            );
        }

        return settings;
    }
);

// Call this function in your plugin's main file
