/**
 * @package   OSWistia
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2014 Wistia. All rights reserved
 */
/* global Wistia */

/**
 * The original file can be found here: //fast.wistia.com/labs/dim-the-lights/plugin.js
 */

// Generated by CoffeeScript 1.6.3
(function(W) {
    var bindEvent, docHeight, docWidth, isBoxModel, pageOffset, removeElem;
    isBoxModel = null;
    pageOffset = function(elem) {
        var body, box, clientLeft, clientTop, docElem, scrollLeft, scrollTop, win;
        body = document.body;
        win = document.defaultView || document.window;
        docElem = document.documentElement;
        if (isBoxModel == null) {
            box = document.createElement('div');
            box.style.paddingLeft = box.style.width = "1px";
            body.appendChild(box);
            isBoxModel = box.offsetWidth === 2;
            body.removeChild(box);
        }
        box = elem.getBoundingClientRect();
        clientTop = docElem.clientTop || body.clientTop || 0;
        clientLeft = docElem.clientLeft || body.clientLeft || 0;
        if ((win != null ? win.pageYOffset : void 0) != null) {
            scrollTop = win.pageYOffset;
            scrollLeft = win.pageXOffset;
        } else {
            scrollTop = (isBoxModel && docElem.scrollTop) || body.scrollTop;
            scrollLeft = (isBoxModel && docElem.scrollLeft) || body.scrollLeft;
        }
        return {
            top: box.top + scrollTop - clientTop,
            left: box.left + scrollLeft - clientLeft
        };
    };
    if (W.detect.browser.msie) {
        bindEvent = function(elem, event, fn) {
            return elem.attachEvent("on" + event, fn);
        };
    } else {
        bindEvent = function(elem, event, fn) {
            return elem.addEventListener(event, fn, false);
        };
    }
    removeElem = function(elem) {
        var par;
        if (elem && (par = elem.parentNode)) {
            par.removeChild(elem);
            return elem = null;
        }
    };
    docHeight = function() {
        var body, html;
        body = document.body;
        html = document.documentElement;
        return Math.max(body.scrollHeight, body.offsetHeight, html.clientHeight, html.scrollHeight, html.offsetHeight);
    };
    docWidth = function() {
        var body, html;
        body = document.body;
        html = document.documentElement;
        return Math.max(body.scrollWidth, body.offsetWidth, html.clientWidth, html.scrollWidth, html.offsetWidth);
    };
    return W.plugin("dimthelights", function(video, options) {
        var addStyle, autoDimOff, autoDimOn, container, dim, dimmed, elem, elems, k, positionElems, removeStyle, styleElem, undim, uuid, _i, _len, _ref;
        if (options == null) {
            options = {};
        }
        if (/popover=true/.test(video.src)) {
            return;
        }
        positionElems = function() {
            var offset, videoHeight, videoWidth, videoX, videoY;
            if (!dimmed) {
                return;
            }
            offset = pageOffset(container);
            videoX = offset.left;
            videoY = offset.top;
            videoWidth = video.width();
            videoHeight = video.height();
            elems.left.style.width = "" + videoX + "px";
            elems.left.style.height = "" + (docHeight()) + "px";
            elems.left.style.left = "0px";
            elems.left.style.top = "0px";
            elems.right.style.width = "" + (docWidth() - videoX - videoWidth) + "px";
            elems.right.style.height = "" + (docHeight()) + "px";
            elems.right.style.left = "" + (videoX + videoWidth) + "px";
            elems.right.style.top = "0px";
            elems.top.style.width = "" + videoWidth + "px";
            elems.top.style.height = "" + videoY + "px";
            elems.top.style.left = "" + videoX + "px";
            elems.top.style.top = "0px";
            elems.bottom.style.width = "" + videoWidth + "px";
            elems.bottom.style.height = "" + (docHeight() - videoY - videoHeight) + "px";
            elems.bottom.style.left = "" + videoX + "px";
            return elems.bottom.style.top = "" + (videoY + videoHeight) + "px";
        };
        dimmed = false;
        dim = function() {
            var elem, k, reposition, v;
            dimmed = true;
            addStyle();
            container.className = container.className.replace(/\s*wistia-dim-target/g, "") + " wistia-dim-target";
            document.body.className = (document.body.className || "").replace(/\s*wistia-dim-the-lights/g, "") + " wistia-dim-the-lights";
            for (k in elems) {
                v = elems[k];
                document.body.appendChild(v);
            }
            positionElems();
            for (k in elems) {
                elem = elems[k];
                elem.className = elem.className.replace(/\s*wistia-invisible/g, "") + " wistia-visible";
            }
            reposition = function() {
                positionElems();
                return dimmed && Wistia.timeout("" + video.uuid + ".dim.reposition", reposition, 300);
            };
            return reposition();
        };
        undim = function() {
            var elem, k, _results;
            dimmed = false;
            container.className = container.className.replace(/\s*wistia-dim-target/g, "");
            document.body.className = (document.body.className || "").replace(/\s*wistia-dim-the-lights/g, "");
            _results = [];
            for (k in elems) {
                elem = elems[k];
                _results.push((function(elem) {
                    elem.className = elem.className.replace(/\s*wistia-visible/g, "") + " wistia-invisible";
                    return W.timeout("" + uuid + ".undim." + k, function() {
                        removeElem(elem);
                        return removeStyle();
                    }, 500);
                })(elem));
            }
            return _results;
        };
        styleElem = null;
        removeStyle = function() {
            return removeElem(styleElem);
        };
        addStyle = function() {
            var prop, t, transitionCss;
            removeStyle();
            prop = "opacity";
            t = .5;
            transitionCss = "-webkit-transition: " + prop + " " + t + "s ease-in-out;\n-moz-transition: " + prop + " " + t + "s ease-in-out;\n-o-transition: " + prop + " " + t + "s ease-in-out;\n-ms-transition: " + prop + " " + t + "s ease-in-out;\ntransition: " + prop + " " + t + "s ease-in-out;";
            return styleElem = W.util.addInlineCss(document.body, ".wistia-dim-backdrop {\nbackground-color:" + options.backgroundColor + ";\ncursor:pointer;\nfilter:alpha(opacity=0);\nopacity:0;\nz-index:16777271;\nposition: absolute;\n}\n.wistia-dim-backdrop.wistia-visible {\nfilter:alpha(opacity=" + (Math.round(options.backgroundOpacity * 100)) + ");\nopacity:" + options.backgroundOpacity + ";\n" + transitionCss + "\n}\n.wistia-dim-backdrop.wistia-invisible {\nfilter:alpha(opacity=0);\nopacity:0;\n" + transitionCss + "\n}\n.wistia-dim-target {\nbox-shadow:0 0 50px 5px rgba(0,0,0,.95);\n}\n.wistia-dim-the-lights textarea {\nresize:none!important;\n}");
        };
        autoDimOff = function() {
            options.autoDim = false;
            return video.unbind("play", dim);
        };
        autoDimOn = function() {
            autoDimOff();
            options.autoDim = true;
            return video.bind("play", dim);
        };
        uuid = W.seqId();
        options = W.extend({
            backgroundColor: "#000000",
            backgroundOpacity: .6,
            autoDim: true
        }, options);
        options.autoDim = W.obj.cast(options.autoDim);
        container = video.iframe ? video.iframe : video.container;
        elems = {};
        _ref = ['left', 'right', 'top', 'bottom'];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            k = _ref[_i];
            elems[k] = document.createElement("div");
            elems[k].id = "" + uuid + "_" + k;
            elems[k].className = "wistia-dim-backdrop";
        }
        for (k in elems) {
            elem = elems[k];
            bindEvent(elem, "click", undim);
        }
        if (options.autoDim) {
            autoDimOn();
        }
        video.bind("widthchanged", positionElems);
        video.bind("heightchanged", positionElems);
        bindEvent(window, "resize", positionElems);
        bindEvent(window, "scroll", positionElems);
        video.bind("down", undim);
        return {
            dim: dim,
            undim: undim,
            elems: elems,
            reposition: positionElems,
            autoDimOff: autoDimOff,
            autoDimOn: autoDimOn
        };
    });
})(Wistia);
