<?php

namespace Embedpress\Pro\Classes;

if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

class Migration
{

    /**
     * Plugin activation hook
     *
     * @since 2.0.0
     */
    public function plugin_activation_hook()
    {
        // make free version available
        set_transient('embedpress_install', true, 1800);
    }

    /**
     * Plugin migrator
     *
     * @since 2.0.0
     */
    public function migrator()
    {
        // migration trick
        if (get_option('embedpress_pro_version') != EMBEDPRESS_PRO_PLUGIN_VERSION) {
            // set current version to db
            update_option('embedpress_pro_version', EMBEDPRESS_PRO_PLUGIN_VERSION);

            /**
             * Tricky update here
             *
             * @since 2.0.0
             */

            // make lite version available
            set_transient('embedpress_install', true, 1800);

            $this->license_migration();

        }

        // check for lite version
        if (get_transient('embedpress_install') && EMBEDPRESS_DEV_MODE === false) {
            // install lite version
            Helper::make_lite_available();
        }
    }

    public function license_migration() {
        $license_key = get_option( EMBEDPRESS_SL_ITEM_SLUG . '-license-key', false);

        if( $license_key !== false ) {
            $license_status = get_option( EMBEDPRESS_SL_ITEM_SLUG . '-license-status');
            $license_data   = get_transient( EMBEDPRESS_SL_ITEM_SLUG . '-license_data');

            update_option( EMBEDPRESS_SL_DB_PREFIX . "_license", $license_key, 'no' );
            update_option( EMBEDPRESS_SL_DB_PREFIX . "_license_status", $license_status, 'no' );
            set_transient( EMBEDPRESS_SL_DB_PREFIX . "_license_data", $license_data, MONTH_IN_SECONDS * 3 );
        }
    }
}
