<?php

namespace Embedpress\Pro\Filters;


if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

class Calendly
{
    public function __construct()
    {
        // Add action hook for handling URLs
        add_action('embedpress/calendly_event_data', [$this, 'calendly_event_data'], 10, 3);
        add_action('embedpress/connected_text_label', [$this, 'connected_text_label'], 10, 2);

        add_action('embedpress/calendly_sync_button', [$this, 'calendly_sync_button'], 10, 2);
        add_action('embedpress/calendly_connect_text_label', [$this, 'calendly_connect_text_label'], 10, 2);
    }

    public function calendly_event_data($event_types, $scheduled_events, $invite_list)
    {
        if (empty($event_types['title'])) {
            update_option('calendly_event_types', $event_types);
            update_option('calendly_scheduled_events', $scheduled_events);
            update_option('calendly_invitees_list', $invite_list);
        }
    }

    public function connected_text_label($is_calendly_connected, $event_types)
    {
        if (!$is_calendly_connected) :
            echo esc_html__('Please connect with calendly.', 'embedpress-pro');
        elseif ($is_calendly_connected && isset($event_types) && count($event_types) < 1) :
            echo esc_html__('Calendly has no events.', 'embedpress-pro');
        endif;
    }

    public function calendly_sync_button($is_calendly_connected, $calendly_sync_url)
    {
        // Check if Calendly is connected and EmbedPress Pro is active
        if ($is_calendly_connected) : ?>
            <div class="calendly-sync-button">
                <a href="<?php echo esc_url($calendly_sync_url); ?>" class="calendly-connect-button" target="_self" title="<?php echo esc_attr__('Sync new Calendly data', 'embedpress'); ?>">
                    <span class="dashicons dashicons-update-alt emcs-dashicon"></span>
                    <?php echo esc_html__('Sync', 'embedpress'); ?>
                </a>
            </div>
<?php endif;
    }

    public function calendly_connect_text_label($is_calendly_connected, $sorted_events)
    {
        if (!$is_calendly_connected) :
            echo '<br>' . esc_html__('Please connect with calendly', 'embedpress');
        elseif ($is_calendly_connected && count($sorted_events) < 1) :
            echo esc_html__('Calendly has no schedule.', 'embedpress');
        endif;
    }
}
