<?php

namespace Embedpress\Pro\Filters;

use EmbedPress\Includes\Classes\Elementor_Enhancer;

if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

class Elementor_Enhancer_Pro
{
    public function __construct()
    {
        // Add action hook for handling URLs
        add_filter('embedpress/elementor_enhancer_youtube', [$this, 'elementor_enhancer_youtube'], 10, 2);
        add_filter('embedpress/elementor_enhancer_youtube_cta', [$this, 'elementor_enhancer_youtube_cta'], 10, 2);

        add_filter('embedpress/elementor_enhancer_vimeo', [$this, 'elementor_enhancer_vimeo'], 10, 2);
        add_filter('embedpress/elementor_enhancer_vimeo_cta', [$this, 'elementor_enhancer_vimeo_cta'], 10, 2);

        add_filter('embedpress/elementor_enhancer_wistia', [$this, 'elementor_enhancer_wistia'], 10, 2);

        add_filter('embedpress/elementor_enhancer_wistia_captions', [$this, 'elementor_enhancer_wistia_captions'], 10, 3);
        add_filter('embedpress/elementor_enhancer_wistia_pluginlist', [$this, 'elementor_enhancer_wistia_pluginlist'], 10, 3);
        add_filter('embedpress/elementor_enhancer_wistia_cta', [$this, 'elementor_enhancer_wistia_cta'], 10, 2);

        add_filter('embedpress/elementor_enhancer_soundcloud', [$this, 'elementor_enhancer_soundcloud'], 10, 2);

        add_filter('embedpress/elementor_enhancer_dailymotion', [$this, 'elementor_enhancer_dailymotion'], 10, 2);

        add_filter('embedpress/elementor_enhancer_dailymotion_cta', [$this, 'elementor_enhancer_dailymotion_cta'], 10, 2);

        add_filter('embedpress/elementor_enhancer_twitch', [$this, 'elementor_enhancer_twitch'], 10, 2);

        add_filter('embedpress/elementor_enhancer_twitch_cta', [$this, 'elementor_enhancer_twitch_cta'], 10, 2);
    }

    public function elementor_enhancer_youtube($params, $setting)
    {
        $params['modestbranding'] = $setting['embedpress_pro_youtube_modest_branding'];
        if ($setting['embedpress_pro_youtube_force_closed_captions'] === 'yes') {
            $params['cc_load_policy'] = 1;
        }

        return $params;
    }

    public function elementor_enhancer_youtube_cta($embed, $setting)
    {
        $embed = Elementor_Enhancer::apply_cta_markup($embed, $setting, 'youtube');

        return $embed;
    }

    public function elementor_enhancer_vimeo($params, $setting)
    {
        if ($setting['embedpress_pro_vimeo_loop'] === 'yes') {
            $params['loop'] = 1;
        }
        if ($setting['embedpress_pro_vimeo_autopause'] === 'yes') {
            $params['autopause'] = 1;
        }

        if ($setting['embedpress_pro_vimeo_autopause'] !== 'yes') {
            $params['dnt'] = $setting['embedpress_pro_vimeo_dnt'] === 'yes' ? 1 : 0;
        }

        return $params;
    }


    public function elementor_enhancer_vimeo_cta($embed, $setting)
    {
        $embed = Elementor_Enhancer::apply_cta_markup($embed, $setting, 'vimeo');

        return $embed;
    }

    public function elementor_enhancer_wistia($embedOptions, $setting)
    {
        $embedOptions->volumeControl = ($setting['embedpress_pro_wistia_volume_control'] === 'yes');

        $volume = isset($setting['embedpress_pro_wistia_volume']['size']) ? (float) $setting['embedpress_pro_wistia_volume']['size'] : 0;
        if ($volume > 1) {
            $volume = $volume / 100;
        }
        $embedOptions->volume = $volume;

        return $embedOptions;
    }

    public function elementor_enhancer_wistia_captions($embedOptions, $setting, $pluginList)
    {

        
        if ($setting['embedpress_pro_wistia_captions'] === 'yes') {
            $isCaptionsEnabled          = ($setting['embedpress_pro_wistia_captions'] === 'yes');
            $isCaptionsEnabledByDefault = ($setting['embedpress_pro_wistia_captions'] === 'yes');
            if ($isCaptionsEnabled) {
                $pluginList['captions-v1'] = [
                    'onByDefault' => $isCaptionsEnabledByDefault,
                ];
            }
            $embedOptions->captions        = $isCaptionsEnabled;
            $embedOptions->captionsDefault = $isCaptionsEnabledByDefault;
        }


        return $embedOptions;
    }
    public function elementor_enhancer_wistia_pluginlist($embedOptions, $setting, $pluginList)
    {

        
        if ($setting['embedpress_pro_wistia_captions'] === 'yes') {
            $isCaptionsEnabled          = ($setting['embedpress_pro_wistia_captions'] === 'yes');
            $isCaptionsEnabledByDefault = ($setting['embedpress_pro_wistia_captions_enabled_by_default'] === 'yes');
            if ($isCaptionsEnabled) {
                $pluginList['captions-v1'] = [
                    'onByDefault' => $isCaptionsEnabledByDefault,
                ];
            }
            $embedOptions->captions        = $isCaptionsEnabled;
            $embedOptions->captionsDefault = $isCaptionsEnabledByDefault;
        }


        return $pluginList;
    }

    public function elementor_enhancer_wistia_cta($embed, $setting)
    {
        $embed = Elementor_Enhancer::apply_cta_markup($embed, $setting, 'wistia');

        return $embed;
    }

    public function elementor_enhancer_soundcloud($params, $setting)
    {
        $params['buying']   = $setting['embedpress_pro_soundcloud_buy_button'] === 'yes' ? 'true' : 'false';
        $params['download'] = $setting['embedpress_pro_soundcloud_download_button'] === 'yes' ? 'true' : 'false';

        return $params;
    }

    public function elementor_enhancer_dailymotion($params, $setting)
    {
        $params['ui-logo'] = isset($setting['embedpress_pro_dailymotion_ui_logo']) && ($setting['embedpress_pro_dailymotion_ui_logo'] === 'yes') ? 1 : 0;

        return $params;
    }

    public function elementor_enhancer_dailymotion_cta($embed, $setting)
    {
        return Elementor_Enhancer::apply_cta_markup($embed, $setting, 'dailymotion');
    }

    public function elementor_enhancer_twitch($layout, $settings)
    {
        $layout = ('yes' === $settings['embedpress_pro_twitch_chat']) ? 'video-with-chat' : $layout;

        return $layout;
    }

    public function elementor_enhancer_twitch_cta($embed, $setting)
    {
        return Elementor_Enhancer::apply_cta_markup($embed, $setting, 'twitch');
    }
}
