<?php

namespace Embedpress\Pro\Filters;

use Embedpress_Google_Helper;


if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

class Feature_Enhancer_Pro
{
    public function __construct()
    {
        // Add action hook for handling URLs
        add_filter('embedpress_enhance_soundcloud', [$this, 'embedpress_enhance_soundcloud'], 10, 2);
        add_filter('embedpress_enhance_dailymotion', [$this, 'embedpress_enhance_dailymotion'], 10, 2);
        add_filter('embedpress_wistia_block_attributes', [$this, 'embedpress_wistia_block_attributes'], 10, 2);
    }

    public function embedpress_enhance_soundcloud($params, $options)
    {
        $params['buying'] = isset($options['buy_button']) && $options['buy_button'] == '1' ? 'true' : 'false';
        $params['download'] = isset($options['download_button']) && $options['download_button'] == '1' ? 'true' : 'false';

        return $params;
    }

    public function embedpress_enhance_dailymotion($params, $options)
    {
        $params['ui-logo'] = (int) isset($options['show_logo']) ? $options['show_logo'] : null;

        return $params;
    }

    public function embedpress_wistia_block_attributes($embedOptions, $attributes)
    {
        $embedOptions->volumeControl = (isset($attributes['volumecontrol']) && (bool) $attributes['volumecontrol'] === true);

        $volume = isset($attributes['volume']) ? (float) $attributes['volume'] : 0;

        if ($volume > 1) {
            $volume = $volume / 100;
        }
        $embedOptions->volume = $volume;

        return $embedOptions;
    }
}
