<?php

namespace Embedpress\Pro\Filters;
use EmbedPress\Includes\Classes\Helper;

if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

class Utility
{
    public function __construct()
    {
        // Add action hook for handling URLs
        add_filter('embed_apple_podcast', [$this, 'embedpress_embed_apple_podcast'], 10, 4);
        add_filter('embedpress/pro_text', [$this, 'pro_text'], 10, 1);
        add_filter('embedpress/pro_class', [$this, 'pro_text'], 10, 1);
        add_filter('embedpress/pro_label', [$this, 'pro_label'], 10, 1);
        add_filter('embedpress/is_allow_rander', [$this, 'is_allow_rander'], 10, 1);
        add_filter('embedpress/generate_ad_template', [$this, 'generate_ad_template'], 10, 4);


        add_action('embedpress/display_password_form', [$this, 'display_password_form'], 10, 4);
        add_action('embedpress/content_protection_content', [$this, 'content_protection_content'], 10, 3);
        add_action('embedpress/instafeed_reaction_count', [$this, 'instafeed_reaction_count'], 10, 3);
        add_action('embedpress/instafeed_tab_option', [$this, 'instafeed_tab_option'], 10);
    }

    public function embedpress_embed_apple_podcast($html, $url, $template, $serviceProvider)
    {
        if (strpos($url, 'podcasts.apple.com')) {
            $iframe_url = str_replace('podcasts.apple.com', 'embed.podcasts.apple.com', $url);
            $html = '<iframe allow="autoplay *; encrypted-media *; fullscreen *" frameborder="0" height="175" style="width:100%;max-width:660px;overflow:hidden;background:transparent;" src="' . esc_url($iframe_url) . '"></iframe>';
            return str_replace('{html}', $html, $template);
        }

        return $html;
    }

    public function pro_text($text)
    {
        $text = '';
        return $text;
    }
    public function pro_class($class)
    {
        $class = '';
        return $class;
    }
    public function pro_label($label)
    {
        $label = '';
        return $label;
    }
    public function display_password_form($client_id = '', $embedHtml = '', $pass_hash_key = '', $attributes = [])
	{
		$lock_heading = !empty($attributes['lockHeading']) ? sanitize_text_field($attributes['lockHeading']) : 'Content Locked';
		$lock_subheading = !empty($attributes['lockSubHeading']) ? sanitize_text_field($attributes['lockSubHeading']) : 'Content is locked and requires password to access it.';
		$lock_error_message = !empty($attributes['lockErrorMessage']) ? sanitize_text_field($attributes['lockErrorMessage']) : "Oops, that wasn't the right password. Try again.";
		$footer_message = !empty($attributes['footerMessage']) ? sanitize_text_field($attributes['footerMessage']) : "In case you don't have the password, kindly reach out to content owner or administrator to request access.";
		$password_placeholder = !empty($attributes['passwordPlaceholder']) ? sanitize_text_field($attributes['passwordPlaceholder']) : 'Password';
		$button_text = !empty($attributes['submitButtonText']) ? sanitize_text_field($attributes['submitButtonText']) : 'Unlock';
		$unlocking_text = !empty($attributes['submitUnlockingText']) ? sanitize_text_field($attributes['submitUnlockingText']) : 'Unlocking';
		$enable_footer_message = !empty($attributes['enableFooterMessage']);

		$key = Helper::get_hash();
		$salt = wp_salt(32);
		$wp_hash_key = hash('sha256', $salt . $pass_hash_key);
		$iv = substr($wp_hash_key, 0, 16);

		$cipher = openssl_encrypt($embedHtml, 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $iv);
		$encrypted_data = base64_encode($cipher);

		update_post_meta(get_the_ID(), 'ep_base_' . $client_id, $encrypted_data);
		update_post_meta(get_the_ID(), 'hash_key_' . $client_id, $wp_hash_key);

		$lock_icon = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64"><g fill="#6354a5" class="color134563 svgShape"><path d="M46.3 28.7h-3v-6.4C43.3 16.1 38.2 11 32 11c-6.2 0-11.3 5.1-11.3 11.3v6.4h-3v-6.4C17.7 14.4 24.1 8 32 8s14.3 6.4 14.3 14.3v6.4" fill="#6354a5" class="color000000 svgShape"></path><path d="M44.8 55.9H19.2c-2.6 0-4.8-2.2-4.8-4.8V31.9c0-2.6 2.2-4.8 4.8-4.8h25.6c2.6 0 4.8 2.2 4.8 4.8v19.2c0 2.7-2.2 4.8-4.8 4.8zM19.2 30.3c-.9 0-1.6.7-1.6 1.6v19.2c0 .9.7 1.6 1.6 1.6h25.6c.9 0 1.6-.7 1.6-1.6V31.9c0-.9-.7-1.6-1.6-1.6H19.2z" fill="#6354a5" class="color000000 svgShape"></path><path d="M35.2 36.7c0 1.8-1.4 3.2-3.2 3.2s-3.2-1.4-3.2-3.2 1.4-3.2 3.2-3.2 3.2 1.5 3.2 3.2" fill="#6354a5" class="color000000 svgShape"></path><path d="M32.8 36.7h-1.6l-1.6 9.6h4.8l-1.6-9.6" fill="#6354a5" class="color000000 svgShape"></path></g></svg>';

		echo '
		<div class="password-form-container">
			<h2>' . esc_html($lock_heading) . '</h2>
			<p>' . esc_html($lock_subheading) . '</p>
			<form class="password-form" method="post" data-unlocking-text="' . esc_attr($unlocking_text) . '">
				<div class="password-field">
					<span class="lock-icon">' . $lock_icon . '</span>
					<input type="password" name="pass_' . esc_attr($client_id) . '" placeholder="' . esc_attr($password_placeholder) . '" required>
				</div>
				<input type="hidden" name="ep_client_id" value="' . esc_attr($client_id) . '">
				<input type="hidden" name="post_id" value="' . esc_attr(get_the_ID()) . '">
				<input type="submit" name="password_submit" value="' . esc_attr($button_text) . '">
				<div class="error-message hidden">' . esc_html($lock_error_message) . '</div>
			</form>
			' . ($enable_footer_message ? '<p class="need-access-message">' . esc_html($footer_message) . '</p>' : '') . '
		</div>';
	}


	public function content_protection_content($client_id = '', $protection_message = '', $allowed_roles = []) {
		$default_message = "This content is protected. Please log in or contact the administrator for access.";
		$protection_message = $protection_message ?: $default_message;
	
		$current_user = wp_get_current_user();
		$user_roles = $current_user->roles;
	
		if (!empty($user_roles) && array_intersect($user_roles, $allowed_roles)) {
			echo '';
			return;
		}
	
		if (strpos($protection_message, '[user_roles]') !== false) {
			$role_list = implode(', ', $allowed_roles);
			$protection_message = str_replace('[user_roles]', $role_list, $protection_message);
		}
	
		echo sprintf('<div class="protected-message">%s</div>', esc_html($protection_message));
	}


    public function is_allow_rander($is_rander)
    {
        return true;
    }

    public function generate_ad_template($embed_content, $client_id, $attributes, $editor)
    {
        // Example usage
        $adSource = isset($attributes['adSource']) ? $attributes['adSource'] : '';
        $adContent = isset($attributes['adContent']) ? $attributes['adContent'] : '';
        $unit = isset($attributes['unitoption']) ? $attributes['unitoption'] : 'px';

        if ($editor === 'elementor') {
            if ($attributes['adSource'] === 'video') {
                $adFileUrl = isset($attributes['adFileUrl']['url']) ? $attributes['adFileUrl']['url'] : '';
            } else if ($attributes['adSource'] === 'image') {
                $adFileUrl = isset($attributes['adFileUrl1']['url']) ? $attributes['adFileUrl1']['url'] : '';
            } else {
                $adFileUrl = isset($attributes['adFileUrl2']['url']) ? $attributes['adFileUrl2']['url'] : '';
            }

            $width = isset($attributes['width']) ? $attributes['width']['size'] : '600';
            $height = isset($attributes['height']) ? $attributes['height']['size'] : '550';
        } else {
            $adFileUrl = isset($attributes['adFileUrl']) ? $attributes['adFileUrl'] : '';
            $width = isset($attributes['width']) ? $attributes['width'] : '600';
            $height = isset($attributes['height']) ? $attributes['height'] : '550';
        }
        $adStart = isset($attributes['adStart']) ? intval($attributes['adStart']) : 0;
        $adUrl = isset($attributes['adUrl']) ? $attributes['adUrl'] : '';
        $adXPosition = isset($attributes['adXPosition']) ? $attributes['adXPosition'] : '';
        $adYPosition = isset($attributes['adYPosition']) ? $attributes['adYPosition'] : '';
        $adWidth = isset($attributes['adWidth']) ? $attributes['adWidth'] : '';
        $adHeight = isset($attributes['adHeight']) ? $attributes['adHeight'] : '';
        $adSkipButton = isset($attributes['adSkipButton']) ? $attributes['adSkipButton'] : false;
        $adSkipButtonAfter = isset($attributes['adSkipButtonAfter']) ? intval($attributes['adSkipButtonAfter']) : 5;

        $currentTime = 0;
        $showSkipButton = false;
        $videoDuration = 0;

        if ($adContent && isset($adContent['fileLength'])) {
            $videoDuration = Helper::parseDuration($adContent['fileLength']);
        }

        $showSkipButton = true;

        $isYTChannelClass = '';
        if (!empty($attributes['url']) && Helper::is_youtube_channel($attributes['url'])) {
            $isYTChannelClass = ' ep-youtube-channel';
        }

        // ob_start();
        ?>
		<div class="main-ad-template <?php echo esc_attr($adSource);
												echo esc_attr($isYTChannelClass); ?>" id="<?php echo esc_attr('ad-' . $client_id); ?>" style="display:none">
			<div class="ep-ad-container">
				<div class="ep-ad-content" style="position: relative;">
					<?php if (!empty($adUrl)) : ?> <a target="_blank" href="<?php echo esc_url($adUrl); ?>"> <?php endif; ?>
						<?php if ($adSource === 'video') : ?>
							<video class="ep-ad" muted>
								<source src="<?= esc_url($adFileUrl) ?>">
							</video>

							<div class="ad-timer">
								<span class="sponsored-running-time"></span>
								<span class="ad-duration">&nbsp;<?php echo esc_html__('• Ad', 'embedpress'); ?></span>
							</div>
							<div class="progress-bar-container">
								<div class="progress-bar"></div>
							</div>

						<?php else : ?>
							<img class="ep-ad" src="<?= esc_url($adFileUrl) ?>">
						<?php endif; ?>

						<?php if (!empty($adUrl)) : ?>
						</a>
					<?php endif; ?>


					<?php if (!empty($adSkipButton) && !empty($showSkipButton)) : ?>
						<button title="Skip Ad" class="skip-ad-button" style="display: none;">
							<?php echo esc_html__('Skip Ad', 'embedpress'); ?>
						</button>
					<?php endif; ?>

				</div>
			</div>
		</div>

		<style>
			.sponsored-mask .ose-embedpress-responsive {
				position: relative;
			}

			.sponsored-running {
				display: inline-block !important;
			}

			.sponsored-mask .ep-embed-content-wraper::after {
				content: '';
				position: absolute;
				top: 0;
				left: 0;
				right: 0;
				bottom: 0;
			}

			.sponsored-mask .ep-content-protection-enabled .ep-embed-content-wraper::after{
				content: none;
			}

			.ep-embed-content-wraper {
				position: relative;
			}

			.ose-youtube {
				/* display: none !important; */
			}

			[data-sponsored-id="<?php echo esc_attr($client_id) ?>"] .main-ad-template {
				width: <?php echo esc_attr($width); ?><?php echo esc_attr($unit); ?>;
				height: <?php echo esc_attr($height); ?>px;
				max-width: 100%;
				display: inline-block;
			}

			div[data-sponsored-id] {
				position: relative;
				display: inline-block !important;
				max-width: 100%;
				width: 100%;
			}

			.embedpress-document-embed div[data-sponsored-id],
			.embedpress-document-embed .main-ad-template.video {
				width: 100%;
			}

			.ep-percentage-width div[data-sponsored-id] {
				display: block;
			}

			.main-ad-template.image.sponsored-running {
				position: absolute;
				z-index: 1;
				bottom: 75px;
				left: 50%;
				height: auto;
			}

			[data-sponsored-id="<?php echo esc_attr($client_id) ?>"] .main-ad-template.image.sponsored-running {
				width: <?php echo esc_attr($adWidth); ?>px !important;
				height: <?php echo esc_attr($adHeight); ?>px !important;
				bottom: <?php echo esc_attr($adYPosition); ?>%;
				left: <?php echo esc_attr($adXPosition); ?>%;
			}

			[data-sponsored-id="<?php echo esc_attr($client_id) ?>"] .main-ad-template .ep-ad-content,
			[data-sponsored-id="<?php echo esc_attr($client_id) ?>"] .main-ad-template .ep-ad-container,
			.main-ad-template div img {
				height: 100%;
				object-fit: cover;

			}


			.main-ad-template.image.sponsored-running img {
				border-radius: 5px;
			}

			.ep-ad-container {
				position: relative;
			}

			.main-ad-template video,
			.main-ad-template img {
				width: 100%;
				height: 100%;
				background-color: #000;
			}

			.progress-bar-container {
				margin-top: -10px;
				background: #ff000021;
			}

			.progress-bar {
				background: #5be82a;
				height: 5px;
				margin-top: -4px;
				max-width: 100%;
			}

			button.skip-ad-button {
				position: absolute;
				bottom: 15px;
				right: 10px;
				border: none;
				background: #d41556b5 !important;
				color: white !important;
				z-index: 122222222;
				font-size: 14px;
				border-radius: 4px;
				height: 30px;
				width: 80px;
				font-weight: normal;
				display: flex;
				align-items: center;
				justify-content: center;
				cursor: pointer;
				padding: 0;

			}

			.ad-timer {
				position: absolute;
				background: #d41556b5;
				font-size: 14px;
				width: 110px;
				color: white;
				bottom: 15px;
				left: 10px;
				text-align: center;
				border-radius: 4px;
				height: 30px;
				width: 80px;
				font-weight: normal;
				display: flex;
				align-items: center;
				justify-content: center;

			}

			[data-sponsored-id="<?php echo esc_attr($client_id) ?>"] .hidden {
				display: none !important;
			}
		</style>
    <?php

        return $embed_content;
	}

	public function instafeed_reaction_count($params, $like_count, $comments_count)
	{?>
		<div class="insta-item-reaction-count">
				<?php if (!empty($params['instafeedLikesCount']) && $params['instafeedLikesCount'] !== 'false') : ?>
					<div class="insta-gallery-item-likes">
						<?php echo Helper::get_insta_like_icon();
										echo esc_html($like_count); ?>
					</div>
				<?php endif; ?>
				<?php if (!empty($params['instafeedCommentsCount']) && $params['instafeedCommentsCount'] !== 'false') : ?>
					<div class="insta-gallery-item-comments">
						<?php echo Helper::get_insta_comment_icon();
										echo esc_html($comments_count); ?>
					</div>
				<?php endif; ?>
			</div>
		<?php
	}
	public function instafeed_tab_option()
	{?>
		<div class="posts-tab-options">
			<ul class="tabs">
				<li data-media-type="ALL" class="active"><svg class="_ab6-" color="#000" height="20" viewBox="5 5 30 30" width="20">
						<path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="3.3333333333333335" d="M5 5h30v30H5zm10.025 0v30m9.95 -30v30M35 15.025H5m30 9.95H5" /></svg>Posts</li>
				<li data-media-type="VIDEO"><svg class="_ab6-" color="#000" height="20" viewBox="0 0 40 40" width="20">
						<path fill="none" stroke="currentColor" stroke-linejoin="round" stroke-width="3.333" d="M3.415 11.67h33.168" />
						<path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="3.333" d="m22.507 3.335 4.763 8.335M12.012 3.517l4.658 8.153M3.333 20.002v5.748c0 4.748 1.163 6.677 2.677 8.242 1.567 1.513 3.497 2.678 8.243 2.678h11.493c4.747 0 6.677-1.165 8.243-2.678 1.513-1.565 2.677-3.493 2.677-8.242V14.253c0-4.747-1.163-6.677-2.677-8.242-1.566-1.513-3.496-2.678-8.242-2.678H14.253c-4.747 0-6.677 1.165-8.243 2.678-1.513 1.566-2.677 3.496-2.677 8.242Z" />
						<path class="fill-color" d="M16.272 29.44a1.513 1.513 0 0 1-.757-1.312v-8.745a1.515 1.515 0 0 1 2.273-1.313l7.575 4.373a1.515 1.515 0 0 1 0 2.625l-7.575 4.373a1.517 1.517 0 0 1-1.517 0Z" fill-rule="evenodd" /></svg>Reels</li>
				<li data-media-type="CAROUSEL_ALBUM"><svg aria-label="Carousel" class="x1lliihq x1n2onr6" color="#000" height="20" viewBox="0 0 43.636 43.636" width="20">
						<path class="fill-color" d="M31.636 27V10a4.695 4.695 0 0 0-4.727-4.727H10A4.695 4.695 0 0 0 5.273 10v17A4.695 4.695 0 0 0 10 31.727h17c2.545-.091 4.636-2.182 4.636-4.727zm4-13.364v14.636c0 4.091-3.364 7.455-7.455 7.455H13.545c-.545 0-.818.636-.455 1 .909 1 2.182 1.636 3.727 1.636h12.182a9.35 9.35 0 0 0 9.364-9.364V16.818a5.076 5.076 0 0 0-1.636-3.727c-.455-.364-1.091 0-1.091.545z" /></svg>Album</li>
			</ul>
		</div>
		<?php
	}


}
