<?php

namespace Embedpress\Pro\Filters;
use EmbedPress\Includes\Classes\Helper;

if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

class Youtube
{
    public function __construct()
    {
        add_action('embedpress/youtube_grid_layout', [$this, 'youtube_grid_layout'], 10, 6);
        add_action('embedpress/youtube_carousel_layout', [$this, 'youtube_carousel_layout'], 10, 6);
    }

    public function youtube_grid_layout($jsonResult, $gallobj, $options, $data, $channelTitle, $channelThumb)
    {
        if(empty($channelTitle)){
            $channelTitle = isset($data['get_channel_info']['snippet']['title']) ? $data['get_channel_info']['snippet']['title'] : '';
            $channelThumb = isset($data['get_channel_info']['snippet']['thumbnails']['default']['url']) ? $data['get_channel_info']['snippet']['thumbnails']['default']['url'] : '';
        }

        foreach ($jsonResult->items as $item) : ?>
            <?php
            $privacyStatus = isset($item->status->privacyStatus) ? $item->status->privacyStatus : null;
            $thumbnail = Helper::get_thumbnail_url($item, $options['thumbnail'], $privacyStatus);
            $vid = Helper::get_id($item);
            $videoTitle = isset($item->snippet->title) ? $item->snippet->title : '';
            $publishedAt = isset($item->snippet->publishedAt) ? $item->snippet->publishedAt : '';

            if (empty($gallobj->first_vid)) {
                $gallobj->first_vid = $vid;
            }
            if ($privacyStatus == 'private' && $options['hideprivate']) {
                continue;
            }
            ?>
            <div class="item" data-vid="<?php echo $vid; ?>">
                <div class="thumb" style="background: <?php echo "url({$thumbnail}) no-repeat center"; ?>">
                    <div class="play-icon">
                        <img src="<?php echo esc_url(EMBEDPRESS_URL_ASSETS . 'images/youtube/youtube-play.png'); ?>" alt="">
                    </div>
                </div>
                <div class="body youtube-body-content">
                    <div class="description-container">
                        <div class="thumbnail"><img src="<?php echo esc_url($channelThumb ); ?>"/></div>
                        <div class="details">
                            <div class="channel"><?php echo esc_html($channelTitle); ?></div>
                            <div class="title"><?php echo esc_html(Helper::trimTitle($videoTitle, 6)); ?></div>
                            
                            <div class="views-time">
                                 <span class="time"><?php echo esc_html(Helper::timeAgo($publishedAt)); ?></span>
                            </div>
                        </div>
                    </div>
                </div>            
            </div>
        <?php endforeach;
    }

    public function youtube_carousel_layout($jsonResult, $gallobj, $options, $data, $channelTitle, $channelThumb)
    {
        $channelTitle = $data['get_channel_info']['snippet']['title'];
        $channelThumb = $data['get_channel_info']['snippet']['thumbnails']['default']['url'];

        foreach ($jsonResult->items as $item) : ?>
            <?php
            $privacyStatus = isset($item->status->privacyStatus) ? $item->status->privacyStatus : null;
            $thumbnail = Helper::get_thumbnail_url($item, $options['thumbnail'], $privacyStatus);
            $vid = Helper::get_id($item);
            $videoTitle = isset($item->snippet->title) ? $item->snippet->title : '';
            $publishedAt = isset($item->snippet->publishedAt) ? $item->snippet->publishedAt : '';

            if (empty($gallobj->first_vid)) {
                $gallobj->first_vid = $vid;
            }
            if ($privacyStatus == 'private' && $options['hideprivate']) {
                continue;
            }
            ?>
            <div class="item" data-vid="<?php echo $vid; ?>">
                <div class="thumb" style="background: <?php echo "url({$thumbnail}) no-repeat center"; ?>">
                    <div class="play-icon">
                        <img src="<?php echo esc_url(EMBEDPRESS_URL_ASSETS . 'images/youtube/youtube-play.png'); ?>" alt="">
                    </div>
                </div>
                <div class="body youtube-body-content">
                    <div class="description-container">
                        <div class="thumbnail"><img src="<?php echo esc_url($channelThumb ); ?>"/></div>
                        <div class="details">
                            <div class="channel"><?php echo esc_html($channelTitle); ?></div>
                            <div class="title"><?php echo esc_html(Helper::trimTitle($videoTitle, 6)); ?></div>
                            
                            <div class="views-time">
                                 <span class="time"><?php echo esc_html(Helper::timeAgo($publishedAt)); ?></span>
                            </div>
                        </div>
                    </div>
                </div>            
            </div>
        <?php endforeach;
    }

}
